
function gridUtil(p,bg_params,hide_list)	{
	this.p = p;	//html 载体
	this.cur_param = ""; // 当前gird的查询条件
	this.m_params = []; //用于保存初始查询条件(如url传过来的参数)
	this.hide_index = hide_list; //隐藏字段
	this.m_search = $("#id_search", this.p); 
	this.m_gird = $("#id_main_div",this.p).find("table");	//grid DOM本体
	this.bg_params = bg_params; //导出基本url
	this.head_cols = $(".hDivBox th", this.p); //导出基本url
	$("#id_search").find("input:first").focus();
	/*
	 * 绑定点击事件
	 * ......
	 */
	 //绑定"查询"点击事件
	$("#id_header_search",this.m_search).click(do_search);	
	//绑定"统计"点击事件
	$("#id_header_calculate",this.m_search).click(do_calculate);
	//绑定"清除"点击事件
	$("#id_header_clear",this.m_search).click(do_clear);
	/*
	 * 实时获取当前grid Dom本体
	 */
	function get_grid()
	{
		return $("#id_main_div",this.p).find("table");
	}
	this.get_grid = get_grid;
}

/****************** 公共调用部分 **********************/
/*
 * 获取当前grid util
 */
function	get_cur_util(){
	return m_util
}
/*
 * 功能：验证选择日期的有效性  
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com
 */
var valid_date= function(){ 
	if ($("#start").val()=="" || $("#end").val()==""){
		alert(gettext("请选择开始日期和结束日期"));
		return false;
	}
	var st=new Date($("#start").val().replace(/-/g,"/"));
	var et=new Date($("#end").val().replace(/-/g,"/"));
	if(st>et){
		alert(gettext("开始日期不能大于结束日期"));
		return false;
	}
	if(et>new Date()){
		alert(gettext("结束日期不能大于今天"));
		return false;
	}
	if(((et-st)>31*24*60*60*1000)|| (et.getMonth()>st.getMonth() && et.getDate()>=st.getDate())){
		alert(gettext("时间跨度不能超过一个月！"));
		return false;			
	}
	return true
}

/*
 *功能： 调用考勤统计函数 
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com
 */
var processInterval = null;
var processLayer = null;
var processLayerIndex = null;
var requestStamp = '';
var onCalculateProcessRefresh = function(){
	var stamp0 = new Date().getTime();
	$.ajax({
		url: '/att/calculate_progressbar/?stamp='+requestStamp,
		type:'GET',
		dataType:'json',
		timeout: 6 * 1000,
		success: function(callback){
			var data = callback.data[0];
			var title = 'Processing...<br/><font color="red">*Please keep this window untill finished.</font>';
			var total = data['total_len'];
			var calculator = data['calculator'];
			var processed = data['processed'];
			var pending = data['pending'];
			var process_range = data['process_range'];
			var process_time = data['process_time'];
			var processed_time = data['processed_time'];
			var tp = data['tp'];
			var fp = data['fp'];
			//var filename = data['filename'];
			processLayer.find("#process_title").html(title);
			processLayer.find("#process_range").html("Range:"+process_range);
			processLayer.find("#id_total").html("Total:"+total);
			processLayer.find("#id_operator").html("Operator:"+calculator);
			processLayer.find("#id_process_time").html("Process At:"+process_time);
			processLayer.find("#id_processed_time").html("Used:"+processed_time+'s');
			processLayer.find("#id_done").html("Calculated:"+processed);
			processLayer.find("#id_pending").html("Pending:"+pending);
			processLayer.find("#spaceuseddetail").progressBar(tp, {increment:100,barImage: '/media/images/progressbg_green.gif?'+stamp0});
			processLayer.find("#spaceusedtol").progressBar(fp, {increment:100,barImage: '/media/images/progressbg_green.gif?'+stamp0});
			if(fp >= 100 || pending == 0){
				//processLayer.find("#process_title").html('Finished... <br/><font color="red">*Please click download link to get export file.</font>');
				//processLayer.find("#downloadlink").attr('href', '/tmp/report_file/'+filename);
				m_util.m_gird.flexOptions({
					newp :1,
					params : m_util.m_params
				}).flexReload();
				clearInterval(processInterval);
				parent.layer.close(processLayerIndex);
			}
		},
		error:function(){
		}
	});
};
var onCalculateProcess = function(data){
	//var onExportProcessRefresh = function(layero, index){
	var vbox=""
		+"<div id='processWindow'><div id='gz_processStatus' style='background-color:#000000;'></div>"
		+"<div id='show_process_status'>"
		+"  <div id='process_title' style='padding: 5px 0 15px 5px;width:420px;'></div>"
		+"  <div id='detail_process' style='margin:0 10px 10px 20px;width:420px;'>"
		+"      <table align='center' style='border:1'>"
		+"		<tr>"
		+"			<td colspan='2'><label id='process_range'></label></td>"
		+"		</tr>"
		+"		<tr>"
		+"          <td width='200px'><label id='id_total'></label></td>"
		+"          <td width='200px'><label id='id_operator'></label></td>"
		+"      </tr>"
		+"		<tr>"
		+"			<td width='200px'><label id='id_process_time'></label></td>"
		+"			<td width='200px'><label id='id_processed_time'></label></td>"
		+"		</tr>"
		+"		<tr>"
		+"			<td width='200px'><label id='id_done'></label></td>"
		+"			<td width='200px'><label id='id_pending'></label></td>"
		+"		</tr>"
		+"</table>"
		+"  </div>"
		+"  <div id='total_process' style='margin-bottom:15px;width:420px;'>"
		+"      <table align='center' style='width:420px;'><tr>"
		+"          <td colspan='2' height='30px' align='center' style='padding-top:3px;'>"
		+"              <span class='progressBar' id='spaceusedtol'>Processing....</span>"
		+"          </td>"
		+"      </tr>"
		+"<table>"
		+"  </div>"
		+"</div></div>";
	var options = {
		title: gettext("温馨提示"),
		area: ['auto', '250px'],
		skin: 'option_dialog',
		shadeClose: false,
		success: function(layero, index){
			var stamp0 = new Date().getTime();
			processLayer = layero;
			processLayerIndex = index;
			if(data){
				layero.find("#process_title").html('<font color="red">'+gettext("当前考勤计算已经有人在统计,请稍后再做统计！")+'</font>');
				layero.find("#process_title").html(title);
				layero.find("#process_range").html("Range:"+data.process_range);
				layero.find("#id_total").html("Total:"+data.total);
				layero.find("#id_operator").html("Operator:"+data.calculator);
				layero.find("#id_process_time").html("At:"+data.process_time);
				layero.find("#id_processed_time").html("Used:"+data.processed_time);
				layero.find("#id_done").html("Calculated:"+data.processed);
				layero.find("#id_pending").html("Pending:"+data.pending);
				layero.find("#spaceuseddetail").progressBar(data.tp, {increment:100,barImage: '/media/images/progressbg_green.gif?'+stamp0});
				layero.find("#spaceusedtol").progressBar(data.fp, {increment:100,barImage: '/media/images/progressbg_green.gif?'+stamp0});
			}else{
				processInterval = window.setInterval('onCalculateProcessRefresh()', 3000);
			}
		},
		cancel: function(index){
			m_util.m_gird.flexOptions({
				newp :1,
				params : m_util.m_params
			}).flexReload();
			layer.close(index);
			clearInterval(processInterval);
		}
	};
	$(vbox).layerDialog(options);
};
function do_calculate(){
	if (!valid_date())
		return;
	var confirm_options = {
		icon: 3,
		title:gettext('提示'),
		skin: 'action-dialog',
		btn: [gettext("确定"), gettext("取消")],
	};
	parent.layer.confirm(gettext("统计的时间可能会较长，请耐心等待"), confirm_options, function(index) {
		parent.layer.close(index);
		var m_params = m_util.m_params;
		var where = [];
		m_util.m_search.find("input,select").each(function(){
			where.push($(this).attr("name")+"="+$(this).val());
			m_params.push({name: $(this).attr("name"),value: $(this).val()});
		});
		var url = "/att/AttReCalc/?"+where.join("&");
		$.ajax({
			url:url,
			type:"POST",
			dataType: "json",
			timeout: 600000,    //10分钟
			success:function(r_data){
				if(r_data.ret == 'ok'){
					onCalculateProcess();
				}else if(r_data.ret == 1){
					onCalculateProcess(r_data);
				}else{
					var alert_options = {
						icon: 3,
						title:gettext('提示'),
						skin: 'action-dialog',
						btn: [gettext("确定"), gettext("取消")]
					};
					parent.layer.confirm("System Error.", alert_options, function(index) {
						parent.layer.close(index);
					}, function(index){
						parent.layer.close(index);
					});
				}
			}
		});
	}, function(index){
		parent.layer.close(index);
		return ;
	});
}

/*
 * '查询'事件触发
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com
 */
function do_search() {
	var m_params = m_util.m_params;
	m_util.m_search.find("input,select").each(function(){
		m_params.push({name: $(this).attr("name"),value: $(this).val()});
	})
	m_util.m_gird.flexOptions({
		newp :1,
		params : m_params
	}).flexReload();
}
/*
 * 添加'查询'条件事件触发
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com
 */
function update_search(opt) {
	var m_params = m_util.m_params;
	m_params.push(opt);
	m_util.m_gird.flexOptions({
		newp :1,
		params : m_params
	}).flexReload();
}
/*
 * 考勤异常查看功能 
 * 参数：异常项的id值
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 */
function showDetail(ids) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/att/ExceptionAttshifts/?pure&ids=' + ids//iframe的url
	});
	//var option = {
	//	iframe : '/page/att/ExceptionAttshifts/?pure&ids='+ids,
	//	width : 640,
	//	height : 205,
	//	over:false,
	//	drag:false,
	//	max:false,
	//	title:gettext('明细详情'),
	//	fixed:true
	//	}
	//jw.dialog(option);
}
/*
 * 功能：人员编号显示格式化
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 */
function format_pin(tdDiv, id) {
    $(tdDiv).html('<a class="obj_edit_href" ref="'+id+'" onclick="do_update('+id+')" href="javascript:void(0)">'+$(tdDiv).html()+'</a>');
}
/*
 * 行编辑、删除操作显示格式化
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 */
function format_operation(tdDiv, id){
	$(tdDiv).html('<a class="action_op_edit" ref="'+id+'" onclick="do_update('+id+')" href="javascript:void(0)"><span class="edit" style="padding-left: 18px;">编辑</span></a>&nbsp;&nbsp;&nbsp;&nbsp;<a class="action__delete" ref="'+id+'" onclick="do_delete('+id+')" href="javascript:void(0)"><span class="delete" style="padding-left: 18px;">删除</span></a>');
}
/*
 * 功能：编辑操作 
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 参数：id:当前编辑对象的id
 */
function do_update(id){
	var data_model_url = $("#data_model_url").val();
	var app_label = $("#app_label").val();
	window.location.assign("/"+data_model_url+"/"+id+"/?app_label="+app_label);
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：删除操作
 * 参数：id:当前编辑对象的id
 */
function do_delete(id){
	var data_model_url = $("#data_model_url").val();
	var app_label = $("#app_label").val();
	window.location.assign("/"+data_model_url+"/_op_/_delete/?&K="+id);
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 *功能： 通过_op_增加操作
 */
function do_add(action){
	var ref = $("#"+action).attr('ref');
	$("#grid_frame").attr('src',ref);
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：通过_new_增加操作
 */
function do_new(){
	var ref = $('#model_new').attr('ref');
	$("#grid_frame").attr('src',ref);
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：'清除'事件触发 
 */
function do_clear() {
	m_util.m_search.find("input,select").each(function(){
			 switch($(this).attr("type"))
			 {
					 case 'text','textarea':
							 $(this).attr("value","");
							 break;
					 case 'checkbox','radio':
							 $(this).attr("checked",false);
							 break;                                 
					 default:
							 $(this).attr("value","");
							 break;
			 };
	 });
	m_util.m_gird.flexOptions({
		newp :1,
		params : []
	}).flexReload();
}
var exportProcessInterval = null;
var exportProcessLayer = null;
var exportProcessLayerIndex = null;
var exportRequestStamp = '';
var onExportProcessRefresh = function(){
	var stamp0 = new Date().getTime();
	$.ajax({
		url: '/data_progressbar/?stamp='+exportRequestStamp,
		type:'GET',
		dataType:'json',
		timeout: 6 * 1000,
		success: function(callback){
			var data = callback;
			var title = '<i class="icon-spinner icon-spin icon-2x"></i>';
			var filename = data['filename'];
			if (exportProcessLayer.find("#process_title").html() == "") {
				exportProcessLayer.find("#process_title").html(title);
			}
			if(filename != ""){
				parent.layer.close(exportProcessLayerIndex);
				clearInterval(exportProcessInterval);
				var newWindow = window.open("_blank");
				newWindow.location = '/get_export_file/?stamp='+exportRequestStamp;
				//window.open('/get_export_file/?stamp='+exportRequestStamp);
			}
		},
		error:function(){
		}
	});
};
var onExportProcess = function(){
	var vbox=""
		+"<div id='processWindow'><div id='gz_processStatus' style='background-color:#000000;'></div>"
		+"<div id='show_process_status'>"
		+"  <div id='process_title' class='processing_icon'><i class='icon-spinner icon-spin icon-4x'></div>"
		+"</div></div>";
	var options = {
		title: gettext("Processing..."),
		area: ['350px', '350px'],
		skin: 'option_dialog',
		shadeClose: false,
		success: function(layero, index){
			exportProcessLayer = layero;
			exportProcessLayerIndex = index;
			exportProcessInterval = window.setInterval('onExportProcessRefresh()', 3000);
		},
		cancel: function(index){
			layer.close(index);
			clearInterval(exportProcessInterval);
		}
	};
	$(vbox).layerDialog(options);
};
function show_export(com,grid,btn)
{
	var bclass = $(btn).find('span').prop('className');
    var m_util = get_cur_util()
	var m_format = "xls";
	if(bclass == 'export_pdf'){
		m_format = "pdf";
	}else if(bclass == 'export_csv'){
		m_format = "csv";
	}else if(bclass == 'export_txt'){
		m_format = "txt";
	}
    var ex_url = m_util.bg_params.split("?")[0]+"?format="+m_format+"&show_export&"+m_util.cur_param;
    $.ajax(
        {
            type:"POST",
            dataType:"html",
            url:ex_url,
            success:function(data){
				var options = {
					type: 1,
					title:gettext('选择样式'),
					content: data,
					skin: 'action-dialog',
					btn: [gettext('导出'), gettext('退出')],
					yes: function(index, layero){
						exportRequestStamp = new Date().getTime();
						var m_util = get_cur_util();
						var ex_style = layero.find(".export_style").val();
						var per_page = 0;
						if(layero.find("#id_per_page").attr('checked')){
							per_page = 1;
						}
						if(m_util.bg_params.indexOf('reportname') == -1){
							m_util.bg_params = m_util.bg_params+"&reportname="+$("#verbose_name").val()+"&";
						}
						var format = layero.find("#id_format").val();
						var url = m_util.bg_params+"format="+format+"&hide="+m_util.hide_index.join(',')
								+"&"+m_util.cur_param+"&style="+ex_style+"&per_page="+per_page+"&stamp="+exportRequestStamp;
						var has_break_time = layero.find("input[name='has_break_time']:checked").val();
						if(has_break_time){
							url += "&has_break_time="+has_break_time;
						}
						$.ajax({
							url: url,
							dataType: "html",
							type: "GET",
							success: function(callback){
								if(callback.indexOf('ok') != -1){
									layer.close(index);
									onExportProcess();
								}else{
									layer.close(index);
								}
							},
							error: function(a, b, c){

							}
						});
					},
					cancel: function(index){
						layer.close(index)
					}
				};
				$(data).layerDialog(options);
            }
        }
    )
}
function save_option(){
	var m_util = get_cur_util();
	var save_url = m_util.bg_params.split("?")[0]+"?save_option&"+m_util.cur_param;
	var grid = m_util.get_grid();
	var p = m_util.p;
	var heads = $(p).find('.hDivBox th');
	var head_cols = [];
	var head_widths = [];
	for(var i=0; i < heads.length; i++){
		var head_col = heads[i];
		var axis = head_col.axis;
		head_cols.push(axis.replace('col', ''))
		head_widths.push($(head_col).find('div').width())
	}
	var params = {
		"hide": m_util.hide_index.join(','),
		"heads": head_cols.join(','),
		"widths": head_widths.join(',')
	};
	$.ajax({
		url: save_url,
		type: "POST",
		data: params,
		dataType: "json",
		success: function(callback){
			var ret = callback.ret;
			if(ret == "ok"){
				var option = {
					title: gettext("提示"),
					icon: 1,
					btn: [],
					//shade: 0,
					success: function(layero){
						parent.layer.setTop(layero);
					}
				};
				parent.layer.alert(gettext("保存成功"), option)
			}
		},
		error:function(a, b, c){
				var option = {
					title: gettext("提示"),
					icon: 2
				};
				parent.layer.alert(gettext("保存失败"), option)
		}
	});
}
function default_option(){
	var m_util = get_cur_util();
	var save_url = m_util.bg_params.split("?")[0]+"?default_option&"+m_util.cur_param+"&hide="+m_util.hide_index.join(',');
	$.ajax({
		url: save_url,
		type: "POST",
		dataType: "json",
		success: function(callback){
			var ret = callback.ret;
			if(ret == "ok"){
				var option = {
					title: gettext("提示"),
					icon: 1,
					btn: [],
					//shade: 0,
					success: function(layero){
						parent.layer.setTop(layero);
					}
				};
				parent.layer.alert(gettext("Return successfully, Please refresh the report."), option);
			}
		},
		error:function(a, b, c){
				var option = {
					title: gettext("提示"),
					icon: 2
				};
				parent.layer.alert(gettext("保存失败"), option)
		}
	});
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：表格顶部导出增加txt导出
 * 参数：com:当前按钮名
 * 		grid：当前flexigrid表格对象
 */
function do_export(com,grid,btn)
{
	var m_util = get_cur_util();
	var m_format = "xls";
	var bclass = $(btn).find('span').prop('className');
	if(bclass == 'export_pdf'){
		m_format = "pdf";
	}else if(bclass == 'export_csv'){
		m_format = "csv";
	}else if(bclass == 'export_txt'){
		m_format = "txt";
	}
	exportRequestStamp = new Date().getTime();
	//exportType = m_format;
	if(m_util.bg_params.indexOf('reportname') == -1){
		m_util.bg_params = m_util.bg_params+"&reportname="+$("#verbose_name").val()+"&"
	}
	var url = m_util.bg_params+"format="+m_format+"&hide="+m_util.hide_index.join(',')+"&"+m_util.cur_param+"&stamp="+exportRequestStamp;
	$.ajax({
		url: url,
		dataType: "json",
		type: "GET",
		success: function(callback){
			if(callback == 'ok'){
				onExportProcess();
			}else{
			}
		},
		error: function(a, b, c){

		}
	});
	//window.open(url);
//	$("#export_ifm").attr("src",url);
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：表格左边的导出与flex_base_export.js搭配使用
 * 参数：com：导出格式
 * 		reportname：导出名称
 * 		recordstart：从第几条开始
 * 		recordend：到第几条结束
 * 		all：是否全部导出
 */
function do_new_export(com,reportname,recordstart,recordend,all)
{
	var m_format = "xls";
	if (com == "xls"){
		m_format = "xls";
	}else if (com=="pdf"){
		m_format = "pdf";
	}else if (com=="csv"){
		m_format = "csv";
	}else if (com=="txt"){
		m_format = "txt";
	}
	exportRequestStamp = new Date().getTime();
	//var url = m_util.bg_params+"&reportname="+reportname+"&format="+m_format+"&all="+all+"&recordstart="+recordstart+"&recordend="+recordend+"&hide="+m_util.hide_index.join(',')+"&"+m_util.cur_param+"&stamp="+exportRequestStamp;
	var url = m_util.bg_params+"&"+m_util.cur_param;
	var post_params = {
		"reportname": reportname,
		"format": m_format,
		"all": all,
		"recordstart": recordstart,
		"recordend": recordend,
		"hide": m_util.hide_index.join(','),
		"stamp": exportRequestStamp
	};
	$.ajax({
		url: url,
		data: post_params,
		dataType: "json",
		type: "GET",
		success: function(callback){
			if(callback == 'ok'){
				onExportProcess();
			}else{
			}
		},
		error: function(a, b, c){

		}
	});
	//window.open(url)
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 获取当前grid被选择的行数据 
 */
function get_cur_select(index)
{
	var grid = m_util.get_grid();
    var ids = '';  
    $('.trSelected td:nth-child('+(index+1)+') div', grid).each(function(i) {  
            if (i)  ids += ',';  
            ids += $(this).text();  
        });
    return ids;
}

/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 获取当前单元格的值 
 */
function get_cur_cell(index){
	var m_item = $('.trSelected').children('td');
	var m_value = m_item.eq(index-1).children('div').html();
	if (m_value=='&nbsp;')m_value='';
	return m_value;
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 获取页面url参数值
 */
function getQueryString(name)
{
    var reg = new RegExp("(^|\\?|&)"+ name +"=([^&]*)(\\s|&|$)", "i");  
    if (reg.test(location.href)) return unescape(RegExp.$2.replace(/\+/g, " ")); return "";
};


/*
 * grid数据加载前调用
 */
function do_Submit(){
	var p =this;
	var m_param = ''
	for (var i=0;i<p.params.length;i++)
	{
		m_param +='&'+p.params[i].name+'='+p.params[i].value;
	}
    //alert(m_param);
	get_cur_util().cur_param = 'page='+p.newp+'&rp='+p.rp+'&sortname='+p.sortname+'&sortorder='+p.sortorder+'&query='+p.query+'&qtype='+p.qtype+m_param
	//alert(get_cur_util().cur_param);
    return true;
}
/*
 *  列显隐开关回调函数
 */
function do_ToggleCol(cid, visible)
{
	var hide_index = get_cur_util().hide_index;
	if (visible)
	{
		var _tmp = [];
		for (var i=0;i<hide_index.length;i++)
		{
			if (hide_index[i]!=cid){_tmp.push(hide_index[i]);}
		}
		get_cur_util().hide_index = _tmp
	}
	else
	{
		get_cur_util().hide_index.push(cid);
	}
}

/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：表格顶部按钮前台简单逻辑判断
 * 参数：com:当前按钮名
 * 		grid：当前flexigrid表格对象
 */
function toolbar(com, grid){
	var data_model_url = $("#data_model_url").val()
	if (com.toLowerCase()=="save" || com.toLowerCase() == "add"){
		window.location.assign("/"+data_model_url+"/_new_/?_lock=1")
	}else if (com.toLowerCase() =="edit" || com.toLowerCase() == "update"){
		var ids = get_cur_select(1);
		if (!ids){
			alert(gettext("请先勾选"));
			return false;
		}
		if (ids.indexOf(",") > 0){
			alert(gettext("只能选一个"));
			return false;
		}
		window.location.assign("/"+data_model_url+"/"+ids+"/")
	}else {
		var ids = get_cur_select(1);
		if (!ids){
			alert(gettext("请先勾选"));
			return false;
		}
		var ret = ""
		var t_ids = ids.split(",")
		for(i=0;i<t_ids.length;i++){
			ret +='&K='+ t_ids[i]
		}
		window.location.assign("/"+data_model_url+"/_op_/"+com+"/?"+ret);
	}
}
/*
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * 功能：载入考勤参数设置信息
 */
function load_description()
{
	$.ajax({
		url:"/att/getallexcept/",
		dataType:"json",
		type:"POST",
		success:function(ret){
			var html=""
			data=ret.data
			for(var i=0;i<data.length;i++)
			{
				var tmp=data[i]
				html+="<span>"+tmp[0]+":<span class='color_orange'>"+ tmp[2] +"( "+tmp[1]+" )</span></span>&nbsp;&nbsp;";
			}
			$("#id_attexcept_desc").html(html);
		}
	});
}

function pop_dialog(userid, att_date, report) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/payroll/'+report+'/?pure&userid=' + userid + '&att_date='+att_date//iframe的url
	});
};

function pop_exception(ids) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/payroll/ExceptionDetail/?pure&ids=' + ids//iframe的url
	});
};
function pop_leave(userid, att_date, report) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/payroll/LeaveDetail/?pure&userid=' + userid + '&att_date='+att_date//iframe的url
	});
};
function pop_allowance(userid, att_date) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/payroll/AllowanceDetail/?pure&userid=' + userid + '&att_date='+att_date//iframe的url
	});
};
function pop_deduction(userid, att_date) {
	top.layer.open({
		type: 2,
		skin: "action-dialog",
		title: gettext('明细详情'),
		shadeClose: true,
		maxmin: true,
		shade: 0.8,
		area: ['640px', '455px'],
		content: '/page/payroll/DeductionDetail/?pure&userid=' + userid + '&att_date='+att_date//iframe的url
	});
};